# Setup Guide for Candidate Management System

## Required File Structure

Create the following directories and files on your server:

\`\`\`
/home/aigroyal/public_html/hr.aigroyal.co/
├── config/
│   └── database.php
├── classes/
│   ├── User.php
│   ├── Candidate.php
│   ├── Source.php
│   ├── Profile.php
│   └── Interview.php
├── includes/
│   └── session.php
├── ajax/
│   ├── interview-process.php
│   └── edit-candidate.php
├── scripts/
│   ├── create-database.sql
│   ├── seed-data.sql
│   └── import-csv-data.php
├── index.php
├── login.php
├── dashboard.php
├── add-candidate.php
├── search-candidates.php
├── manage-options.php
├── logout.php
├── install.php
├── check-setup.php
├── 404.php
└── .htaccess
\`\`\`

## Quick Setup Steps:

1. **Create Directories:**
   \`\`\`bash
   mkdir config classes includes ajax scripts
   \`\`\`

2. **Upload Files:**
   - Copy all the PHP files to their respective directories
   - Make sure file permissions are correct (644 for files, 755 for directories)

3. **Database Setup:**
   - Create MySQL database named 'candidate_management'
   - Run the SQL scripts in the scripts/ directory
   - Update database credentials in config/database.php

4. **Test Setup:**
   - Visit: http://hr.aigroyal.co/check-setup.php
   - This will verify all files and database connection

5. **Install:**
   - Visit: http://hr.aigroyal.co/install.php
   - This creates the default admin user

6. **Login:**
   - Visit: http://hr.aigroyal.co/
   - Use: admin / password

## Troubleshooting:

If you see "No such file or directory" errors:
1. Check that all directories exist
2. Verify file paths are correct
3. Ensure proper file permissions
4. Check that files are uploaded to the correct locations

## File Permissions:
\`\`\`bash
chmod 755 config classes includes ajax scripts
chmod 644 *.php config/*.php classes/*.php includes/*.php ajax/*.php
