<?php
include_once 'config/database.php';
include_once 'classes/Candidate.php';
include_once 'classes/Source.php';
include_once 'classes/Profile.php';
include_once 'includes/session.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();

$candidate = new Candidate($db);
$source = new Source($db);
$profile = new Profile($db);

$success_message = '';
$error_message = '';

// Handle form submission
if ($_POST) {
    if (isset($_POST['add_source'])) {
        $source->name = $_POST['source_name'];
        $source->description = $_POST['source_name'];
        if ($source->create()) {
            $success_message = "Source added successfully!";
        } else {
            $error_message = "Failed to add source!";
        }
    } elseif (isset($_POST['add_profile'])) {
        $profile->name = $_POST['profile_name'];
        $profile->description = $_POST['profile_name'];
        $profile->department = '';
        if ($profile->create()) {
            $success_message = "Profile added successfully!";
        } else {
            $error_message = "Failed to add profile!";
        }
    } elseif (isset($_POST['add_candidate'])) {
        $candidate->candidate_id = $candidate->generateCandidateId();
        $candidate->name = $_POST['name'];
        $candidate->email = $_POST['email'];
        $candidate->phone = $_POST['phone'];
        $candidate->location = $_POST['location'];
        $candidate->team_name = $_POST['team_name'];
        $candidate->referral_code = $_POST['referral_code'] ?? ''; // New referral code field
        $candidate->lineup_date = $_POST['lineup_date'];
        $candidate->source_id = $_POST['source_id'];
        $candidate->profile_id = $_POST['profile_id'];
        $candidate->status = 'pending';
        $candidate->added_date = date('Y-m-d');
        $candidate->created_by = getUserId();
        
        if ($candidate->create()) {
            header("Location: dashboard.php?success=1");
            exit();
        } else {
            $error_message = "Failed to add candidate!";
        }
    }
}

// Get sources and profiles
$sources_stmt = $source->read();
$profiles_stmt = $profile->read();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Candidate - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .form-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin: 20px 0;
        }
        .form-control, .form-select {
            border-radius: 8px;
            border: 2px solid #e9ecef;
            padding: 10px 15px;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
        }
        .candidate-id {
            background-color: #e9ecef;
            font-weight: bold;
            color: #495057;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">
                <i class="fas fa-users me-2"></i>
                Candidate Management System
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">
                    <i class="fas fa-home me-1"></i>Dashboard
                </a>
                <a href="logout.php" class="btn btn-outline-light btn-sm ms-2">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <?php if ($success_message): ?>
            <div class="alert alert-success alert-dismissible fade show mt-3">
                <i class="fas fa-check-circle me-2"></i><?php echo $success_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if ($error_message): ?>
            <div class="alert alert-danger alert-dismissible fade show mt-3">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo $error_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="form-container">
            <h2 class="mb-4">
                <i class="fas fa-user-plus me-2"></i>Add New Candidate
            </h2>
            
            <form method="POST">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="candidateId" class="form-label">Candidate ID</label>
                        <input type="text" class="form-control candidate-id" value="<?php echo $candidate->generateCandidateId(); ?>" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="addedDate" class="form-label">Date Added</label>
                        <input type="text" class="form-control candidate-id" value="<?php echo date('Y-m-d'); ?>" readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="lineup_date" class="form-label">Lineup Date</label>
                        <input type="date" class="form-control" name="lineup_date" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="name" class="form-label">Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="phone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control" name="phone" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email ID</label>
                        <input type="email" class="form-control" name="email" required>
                    </div>
                </div>
                
                 <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="location" class="form-label">Location</label>
                        <input type="text" class="form-control" name="location" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="team_name" class="form-label">Team Name</label>
                        <input type="text" class="form-control" name="team_name" required>
                    </div>
                </div>

              

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Source</label>
                        <select class="form-select mb-2" name="source_id" required>
                            <option value="">Select Source</option>
                            <?php while ($row = $sources_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                                <option value="<?php echo $row['id']; ?>"><?php echo $row['name']; ?></option>
                            <?php endwhile; ?>
                        </select>
                        <!--<div class="input-group">-->
                        <!--    <input type="text" class="form-control" name="source_name" placeholder="Add new source">-->
                        <!--    <button type="submit" name="add_source" class="btn btn-outline-primary">-->
                        <!--        <i class="fas fa-plus me-1"></i>Add Source-->
                        <!--    </button>-->
                        <!--</div>-->
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Profile</label>
                        <select class="form-select mb-2" name="profile_id" required>
                            <option value="">Select Profile</option>
                            <?php while ($row = $profiles_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                                <option value="<?php echo $row['id']; ?>"><?php echo $row['name']; ?></option>
                            <?php endwhile; ?>
                        </select>
                        <!--<div class="input-group">-->
                        <!--    <input type="text" class="form-control" name="profile_name" placeholder="Add new profile">-->
                        <!--    <button type="submit" name="add_profile" class="btn btn-outline-primary">-->
                        <!--        <i class="fas fa-plus me-1"></i>Add Profile-->
                        <!--    </button>-->
                        <!--</div>-->
                    </div>
                </div>
                  <!-- New Referral Code Field -->
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="referral_code" class="form-label">Referral Code <small class="text-muted">(Optional)</small></label>
                        <input type="text" class="form-control" name="referral_code" placeholder="Enter referral code if any">
                        <div class="form-text">Enter referral code if candidate was referred by someone</div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <!-- Empty column for spacing -->
                    </div>
                </div>

                <div class="text-center">
                    <button type="submit" name="add_candidate" class="btn btn-primary btn-lg">
                        <i class="fas fa-save me-2"></i>Add Candidate
                    </button>
                    <a href="dashboard.php" class="btn btn-secondary btn-lg ms-2">
                        <i class="fas fa-times me-2"></i>Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
