<?php
include_once 'config/database.php';
include_once 'classes/User.php';
include_once 'includes/session.php';

requireLogin();

// Only allow admin users
if (getUserRole() !== 'admin') {
    header("Location: dashboard.php");
    exit();
}

$database = new Database();
$db = $database->getConnection();
$user = new User($db);

$success_message = '';
$error_message = '';

// Handle user creation
if ($_POST && isset($_POST['create_user'])) {
    $user->username = $_POST['username'];
    $user->password_hash = $_POST['password'];
    $user->email = $_POST['email'];
    $user->role = $_POST['role'];
    
    if ($user->create()) {
        $success_message = "User created successfully!";
    } else {
        $error_message = "Failed to create user!";
    }
}

// Handle password reset
if ($_POST && isset($_POST['reset_password'])) {
    $username = $_POST['reset_username'];
    $new_password = $_POST['new_password'];
    
    $query = "UPDATE users SET password_hash = ? WHERE username = ?";
    $stmt = $db->prepare($query);
    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
    
    if ($stmt->execute([$hashed_password, $username])) {
        $success_message = "Password reset successfully for user: $username";
    } else {
        $error_message = "Failed to reset password!";
    }
}

// Get all users
$query = "SELECT id, username, email, role, created_at FROM users ORDER BY created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .navbar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .admin-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">
                <i class="fas fa-users me-2"></i>Candidate Management System
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">
                    <i class="fas fa-home me-1"></i>Dashboard
                </a>
                <a href="logout.php" class="btn btn-outline-light btn-sm ms-2">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <?php if ($success_message): ?>
            <div class="alert alert-success alert-dismissible fade show mt-3">
                <i class="fas fa-check-circle me-2"></i><?php echo $success_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if ($error_message): ?>
            <div class="alert alert-danger alert-dismissible fade show mt-3">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo $error_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <div class="admin-container">
                    <h3><i class="fas fa-user-plus me-2"></i>Create New User</h3>
                    
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">Username</label>
                            <input type="text" class="form-control" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" class="form-control" name="password" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="role" required>
                                <option value="hr">HR</option>
                                <option value="manager">Manager</option>
                                <option value="admin">Admin</option>
                            </select>
                        </div>
                        <button type="submit" name="create_user" class="btn btn-primary">
                            <i class="fas fa-save me-1"></i>Create User
                        </button>
                    </form>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="admin-container">
                    <h3><i class="fas fa-key me-2"></i>Reset Password</h3>
                    
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">Username</label>
                            <select class="form-select" name="reset_username" required>
                                <option value="">Select User</option>
                                <?php foreach ($users as $u): ?>
                                    <option value="<?php echo $u['username']; ?>"><?php echo $u['username']; ?> (<?php echo $u['role']; ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">New Password</label>
                            <input type="password" class="form-control" name="new_password" required>
                        </div>
                        <button type="submit" name="reset_password" class="btn btn-warning">
                            <i class="fas fa-redo me-1"></i>Reset Password
                        </button>
                    </form>
                    
                    <hr>
                    
                    <div class="alert alert-info">
                        <h6><i class="fas fa-info-circle me-2"></i>Default Credentials</h6>
                        <p class="mb-1"><strong>Username:</strong> admin</p>
                        <p class="mb-0"><strong>Password:</strong> password</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="admin-container">
            <h3><i class="fas fa-users me-2"></i>All Users</h3>
            
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $u): ?>
                            <tr>
                                <td><?php echo $u['id']; ?></td>
                                <td><?php echo $u['username']; ?></td>
                                <td><?php echo $u['email']; ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $u['role'] === 'admin' ? 'danger' : ($u['role'] === 'manager' ? 'warning' : 'primary'); ?>">
                                        <?php echo strtoupper($u['role']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('Y-m-d H:i', strtotime($u['created_at'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
