<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';
include_once '../classes/Source.php';
include_once '../classes/Profile.php';
include_once '../includes/session.php';

if (!isLoggedIn()) {
    exit('Unauthorized');
}

$database = new Database();
$db = $database->getConnection();
$candidate = new Candidate($db);
$source = new Source($db);
$profile = new Profile($db);

$candidate_id = $_GET['candidate_id'] ?? '';
$candidate->candidate_id = $candidate_id;

if (!$candidate->readOne()) {
    exit('Candidate not found');
}

$sources_stmt = $source->read();
$profiles_stmt = $profile->read();
?>

<form method="POST" action="search-candidates.php">
    <input type="hidden" name="candidate_id" value="<?php echo $candidate->candidate_id; ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="editName" class="form-label">Name</label>
            <input type="text" class="form-control" name="name" value="<?php echo htmlspecialchars($candidate->name); ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="editLineupDate" class="form-label">Lineup Date</label>
            <input type="date" class="form-control" name="lineup_date" value="<?php echo $candidate->lineup_date; ?>" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="editPhone" class="form-label">Phone</label>
            <input type="tel" class="form-control" name="phone" value="<?php echo $candidate->phone; ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="editEmail" class="form-label">Email</label>
            <input type="email" class="form-control" name="email" value="<?php echo $candidate->email; ?>" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="editLocation" class="form-label">location</label>
            <input type="text" class="form-control" name="location" value="<?php echo $candidate->location; ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="editTeam_name" class="form-label">Team Name</label>
            <input type="text" class="form-control" name="team_name" value="<?php echo $candidate->team_name; ?>" required>
        </div>
    </div>
    
    <!-- New Referral Code Field -->
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="editReferralCode" class="form-label">Referral Code</label>
            <input type="text" class="form-control" name="referral_code" value="<?php echo htmlspecialchars($candidate->referral_code ?? ''); ?>" placeholder="Enter referral code">
        </div>
        <div class="col-md-6 mb-3">
            <label for="editStatus" class="form-label">Status</label>
            <select class="form-select" name="status" required>
                <option value="pending" <?php echo ($candidate->status == 'pending') ? 'selected' : ''; ?>>Pending</option>
                <option value="shortlisted" <?php echo ($candidate->status == 'shortlisted') ? 'selected' : ''; ?>>Shortlisted</option>
                <option value="selected" <?php echo ($candidate->status == 'selected') ? 'selected' : ''; ?>>Selected</option>
                <option value="rejected" <?php echo ($candidate->status == 'rejected') ? 'selected' : ''; ?>>Rejected</option>
                <option value="hold" <?php echo ($candidate->status == 'hold') ? 'selected' : ''; ?>>Hold</option>
                <option value="joined" <?php echo ($candidate->status == 'joined') ? 'selected' : ''; ?>>Joined</option>
                <option value="rescheduled" <?php echo ($candidate->status == 'rescheduled') ? 'selected' : ''; ?>>Rescheduled</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="editSource" class="form-label">Source</label>
            <select class="form-select" name="source_id" required>
                <?php while ($row = $sources_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                    <option value="<?php echo $row['id']; ?>" <?php echo ($row['id'] == $candidate->source_id) ? 'selected' : ''; ?>>
                        <?php echo $row['name']; ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-6 mb-3">
            <label for="editProfile" class="form-label">Profile</label>
            <select class="form-select" name="profile_id" required>
                <?php while ($row = $profiles_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                    <option value="<?php echo $row['id']; ?>" <?php echo ($row['id'] == $candidate->profile_id) ? 'selected' : ''; ?>>
                        <?php echo $row['name']; ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
    </div>
    
    <div class="text-center">
        <button type="submit" name="update_candidate" class="btn btn-success">
            <i class="fas fa-save me-1"></i>Save Changes
        </button>
        <button type="button" class="btn btn-secondary ms-2" data-bs-dismiss="modal">
            <i class="fas fa-times me-1"></i>Cancel
        </button>
    </div>
</form>
