<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';
include_once '../includes/session.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Candidate ID is required']);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $candidate_id = $_GET['id'];
    
    $query = "SELECT c.*, s.name as source_name, p.name as profile_name
              FROM candidates c
              LEFT JOIN sources s ON c.source_id = s.id
              LEFT JOIN profiles p ON c.profile_id = p.id
              WHERE c.id = ?";
    
    $stmt = $db->prepare($query);
    $stmt->execute([$candidate_id]);
    $candidate = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$candidate) {
        throw new Exception('Candidate not found');
    }
    
    echo json_encode([
        'success' => true,
        'candidate' => $candidate
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
