<?php
include_once '../config/database.php';
include_once '../classes/Interview.php';
include_once '../includes/session.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if (!isset($_GET['candidate_id'])) {
    echo json_encode(['success' => false, 'message' => 'Candidate ID is required']);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $interview = new Interview($db);
    $interviews = $interview->getInterviewHistory($_GET['candidate_id']);
    
    echo json_encode([
        'success' => true,
        'interviews' => $interviews
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
