<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once '../config/database.php';
include_once '../includes/session.php';
include_once '../classes/Candidate.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$database = new Database();
$db = $database->getConnection();

if (!$db) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

$candidate_id = $_GET['candidate_id'] ?? '';

if (empty($candidate_id)) {
    echo json_encode(['success' => false, 'message' => 'Candidate ID is required']);
    exit();
}

try {
    // Get candidate details
    $candidate_query = "SELECT * FROM candidates WHERE candidate_id = ?";
    $stmt = $db->prepare($candidate_query);
    $stmt->execute([$candidate_id]);
    $candidate = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$candidate) {
        echo json_encode(['success' => false, 'message' => 'Candidate not found']);
        exit();
    }

    // Get complete interview process history
    $history_query = "SELECT 
                        'interview' as event_type,
                        i.id,
                        i.interview_date as event_date,
                        i.interview_time,
                        i.interview_type,
                        i.duration_minutes,
                        i.status,
                        i.result,
                        i.notes,
                        i.interviewer_name,
                        i.created_at,
                        NULL as original_date,
                        NULL as new_date,
                        NULL as reschedule_reason,
                        NULL as expected_joining_date,
                        NULL as actual_joining_date,
                        NULL as salary_offered,
                        NULL as position,
                        NULL as previous_status,
                        NULL as new_status
                      FROM interviews i 
                      WHERE i.candidate_id = ?
                      
                      UNION ALL
                      
                      SELECT 
                        'reschedule' as event_type,
                        r.id,
                        r.new_date as event_date,
                        NULL as interview_time,
                        'reschedule' as interview_type,
                        NULL as duration_minutes,
                        'completed' as status,
                        'rescheduled' as result,
                        CONCAT('Rescheduled from ', r.original_date, '. Reason: ', r.reason) as notes,
                        u.username as interviewer_name,
                        r.created_at,
                        r.original_date,
                        r.new_date,
                        r.reason as reschedule_reason,
                        NULL as expected_joining_date,
                        NULL as actual_joining_date,
                        NULL as salary_offered,
                        NULL as position,
                        NULL as previous_status,
                        NULL as new_status
                      FROM reschedules r
                      LEFT JOIN users u ON r.rescheduled_by = u.id
                      WHERE r.candidate_id = ?
                      
                      UNION ALL
                      
                      SELECT 
                        'joining' as event_type,
                        j.id,
                        COALESCE(j.actual_joining_date, j.expected_joining_date) as event_date,
                        NULL as interview_time,
                        'joining' as interview_type,
                        NULL as duration_minutes,
                        CASE WHEN j.joining_status = 'joined' THEN 'completed' ELSE 'pending' END as status,
                        j.joining_status as result,
                        j.joining_notes as notes,
                        'HR Team' as interviewer_name,
                        j.created_at,
                        NULL as original_date,
                        NULL as new_date,
                        NULL as reschedule_reason,
                        j.expected_joining_date,
                        j.actual_joining_date,
                        j.salary_offered,
                        j.position,
                        NULL as previous_status,
                        NULL as new_status
                      FROM joining_details j
                      WHERE j.candidate_id = ?
                      
                      UNION ALL
                      
                      SELECT 
                        'status_change' as event_type,
                        csh.id,
                        DATE(csh.changed_at) as event_date,
                        TIME(csh.changed_at) as interview_time,
                        'status_update' as interview_type,
                        NULL as duration_minutes,
                        'completed' as status,
                        csh.new_status as result,
                        csh.reason as notes,
                        u.username as interviewer_name,
                        csh.changed_at as created_at,
                        NULL as original_date,
                        NULL as new_date,
                        NULL as reschedule_reason,
                        NULL as expected_joining_date,
                        NULL as actual_joining_date,
                        NULL as salary_offered,
                        NULL as position,
                        csh.previous_status,
                        csh.new_status
                      FROM candidate_status_history csh
                      LEFT JOIN users u ON csh.changed_by = u.id
                      WHERE csh.candidate_id = ?
                      
                      ORDER BY created_at ASC";
    
    $stmt = $db->prepare($history_query);
    $stmt->execute([$candidate['id'], $candidate['id'], $candidate['id'], $candidate['id']]);
    $process_history = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get current status
    $current_status_query = "SELECT status FROM candidates WHERE id = ?";
    $stmt = $db->prepare($current_status_query);
    $stmt->execute([$candidate['id']]);
    $current_status = $stmt->fetchColumn();

    echo json_encode([
        'success' => true,
        'candidate' => $candidate,
        'current_status' => $current_status,
        'process_history' => $process_history,
        'total_steps' => count($process_history)
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>
