<?php
include_once '../config/database.php';
include_once '../classes/Source.php';
include_once '../classes/Profile.php';
include_once '../includes/session.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $source = new Source($db);
    $profile = new Profile($db);
    
    $sources_stmt = $source->read();
    $profiles_stmt = $profile->read();
    
    $sources = $sources_stmt->fetchAll(PDO::FETCH_ASSOC);
    $profiles = $profiles_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'sources' => $sources,
        'profiles' => $profiles
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
