<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';
include_once '../includes/session.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    $filters = [
        'candidate_id' => $input['candidate_id'] ?? '',
        'name' => $input['name'] ?? '',
        'email' => $input['email'] ?? '',
        'phone' => $input['phone'] ?? '',
        'location' => $input['location'] ?? '',
        'team_name' => $input['team_name'] ?? '',
        'lineup_date' => $input['lineup_date'] ?? '',
        'source_id' => $input['source'] ?? '',
        'profile_id' => $input['profile'] ?? ''
    ];
    
    // Convert source and profile names to IDs if needed
    if (!empty($input['source']) && !is_numeric($input['source'])) {
        $source_query = "SELECT id FROM sources WHERE name = ?";
        $stmt = $db->prepare($source_query);
        $stmt->execute([$input['source']]);
        $source_result = $stmt->fetch(PDO::FETCH_ASSOC);
        $filters['source_id'] = $source_result ? $source_result['id'] : '';
    }
    
    if (!empty($input['profile']) && !is_numeric($input['profile'])) {
        $profile_query = "SELECT id FROM profiles WHERE name = ?";
        $stmt = $db->prepare($profile_query);
        $stmt->execute([$input['profile']]);
        $profile_result = $stmt->fetch(PDO::FETCH_ASSOC);
        $filters['profile_id'] = $profile_result ? $profile_result['id'] : '';
    }
    
    $candidate = new Candidate($db);
    $stmt = $candidate->search($filters);
    $candidates = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'candidates' => $candidates
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
