<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';
include_once '../includes/session.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $candidate_id = $_POST['candidate_id'] ?? '';
    
    if (empty($candidate_id)) {
        throw new Exception('Candidate ID is required');
    }
    
    $db->beginTransaction();
    
    // Get current candidate data for status history
    $current_query = "SELECT status FROM candidates WHERE id = ?";
    $stmt = $db->prepare($current_query);
    $stmt->execute([$candidate_id]);
    $current_candidate = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$current_candidate) {
        throw new Exception('Candidate not found');
    }
    
    // Update candidate
    $update_query = "UPDATE candidates SET 
                     name = ?, email = ?, phone = ?, , location = ?, , team_name = ?, referral_code = ?, 
                     lineup_date = ?, source_id = ?, profile_id = ?, status = ?, 
                     updated_at = NOW()
                     WHERE id = ?";
    
    $stmt = $db->prepare($update_query);
    $result = $stmt->execute([
        $_POST['name'],
        $_POST['email'],
        $_POST['phone'],
        $_POST['location'],
        $_POST['team_name'],
        $_POST['referral_code'] ?? '',
        $_POST['lineup_date'],
        $_POST['source_id'],
        $_POST['profile_id'],
        $_POST['status'],
        $candidate_id
    ]);
    
    if (!$result) {
        throw new Exception('Failed to update candidate');
    }
    
    // Insert status history if status changed
    if ($current_candidate['status'] !== $_POST['status']) {
        $history_query = "INSERT INTO candidate_status_history 
                         (candidate_id, previous_status, new_status, changed_by, reason, changed_at) 
                         VALUES (?, ?, ?, ?, ?, NOW())";
        $stmt = $db->prepare($history_query);
        $stmt->execute([
            $candidate_id,
            $current_candidate['status'],
            $_POST['status'],
            $_SESSION['user_id'],
            'Status updated via edit form'
        ]);
    }
    
    $db->commit();
    
    echo json_encode([
        'success' => true,
        'message' => 'Candidate updated successfully'
    ]);
    
} catch (Exception $e) {
    if (isset($db)) {
        $db->rollback();
    }
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
