<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Setup Checker - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .check-item { margin-bottom: 15px; }
        .check-pass { color: #28a745; }
        .check-fail { color: #dc3545; }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3><i class="fas fa-check-circle me-2"></i>Setup Checker</h3>
                    </div>
                    <div class="card-body">
                        <?php
                        echo "<h5>File Structure Check:</h5>";
                        
                        $required_files = [
                            'config/database.php',
                            'includes/session.php',
                            'classes/User.php',
                            'classes/Candidate.php',
                            'classes/Source.php',
                            'classes/Profile.php',
                            'classes/Interview.php',
                            'ajax/interview-process.php',
                            'ajax/edit-candidate.php'
                        ];
                        
                        foreach ($required_files as $file) {
                            if (file_exists($file)) {
                                echo "<div class='check-item'><i class='fas fa-check check-pass'></i> $file - <span class='check-pass'>Found</span></div>";
                            } else {
                                echo "<div class='check-item'><i class='fas fa-times check-fail'></i> $file - <span class='check-fail'>Missing</span></div>";
                            }
                        }
                        
                        echo "<hr><h5>Database Connection Check:</h5>";
                        
                        if (file_exists('config/database.php')) {
                            include_once 'config/database.php';
                            $database = new Database();
                            $db = $database->getConnection();
                            
                            if ($db) {
                                echo "<div class='check-item'><i class='fas fa-check check-pass'></i> Database Connection - <span class='check-pass'>Success</span></div>";
                                
                                // Check if tables exist
                                $tables = ['users', 'candidates', 'sources', 'profiles', 'interviews'];
                                foreach ($tables as $table) {
                                    try {
                                        $stmt = $db->query("SELECT 1 FROM $table LIMIT 1");
                                        echo "<div class='check-item'><i class='fas fa-check check-pass'></i> Table '$table' - <span class='check-pass'>Exists</span></div>";
                                    } catch (Exception $e) {
                                        echo "<div class='check-item'><i class='fas fa-times check-fail'></i> Table '$table' - <span class='check-fail'>Missing</span></div>";
                                    }
                                }
                            } else {
                                echo "<div class='check-item'><i class='fas fa-times check-fail'></i> Database Connection - <span class='check-fail'>Failed</span></div>";
                            }
                        } else {
                            echo "<div class='check-item'><i class='fas fa-times check-fail'></i> Database config file - <span class='check-fail'>Missing</span></div>";
                        }
                        
                        echo "<hr><h5>PHP Extensions Check:</h5>";
                        
                        $required_extensions = ['pdo', 'pdo_mysql', 'session'];
                        foreach ($required_extensions as $ext) {
                            if (extension_loaded($ext)) {
                                echo "<div class='check-item'><i class='fas fa-check check-pass'></i> $ext - <span class='check-pass'>Loaded</span></div>";
                            } else {
                                echo "<div class='check-item'><i class='fas fa-times check-fail'></i> $ext - <span class='check-fail'>Not Loaded</span></div>";
                            }
                        }
                        ?>
                        
                        <hr>
                        <div class="text-center">
                            <a href="install.php" class="btn btn-primary me-2">
                                <i class="fas fa-tools me-1"></i>Run Installation
                            </a>
                            <a href="index.php" class="btn btn-success">
                                <i class="fas fa-home me-1"></i>Go to System
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
