<?php
class Candidate {
    private $conn;
    private $table_name = "candidates";

    public $id;
    public $candidate_id;
    public $name;
    public $email;
    public $phone;
    public $location;
    public $team_name;
    public $referral_code; // New referral code property
    public $lineup_date;
    public $source_id;
    public $profile_id;
    public $status;
    public $added_date;
    public $created_by;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET candidate_id=:candidate_id, name=:name, email=:email, phone=:phone, location=:location, team_name=:team_name, 
                      referral_code=:referral_code, lineup_date=:lineup_date, source_id=:source_id, 
                      profile_id=:profile_id, status=:status, added_date=:added_date, created_by=:created_by";
        
        $stmt = $this->conn->prepare($query);

        $this->candidate_id = htmlspecialchars(strip_tags($this->candidate_id));
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->email = htmlspecialchars(strip_tags($this->email));
        $this->phone = htmlspecialchars(strip_tags($this->phone));
        $this->location = htmlspecialchars(strip_tags($this->location));
        $this->team_name = htmlspecialchars(strip_tags($this->team_name));
        $this->referral_code = htmlspecialchars(strip_tags($this->referral_code));
        $this->status = htmlspecialchars(strip_tags($this->status));

        $stmt->bindParam(":candidate_id", $this->candidate_id);
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":email", $this->email);
        $stmt->bindParam(":phone", $this->phone);
        $stmt->bindParam(":location", $this->location);
        $stmt->bindParam(":team_name", $this->team_name);
        $stmt->bindParam(":referral_code", $this->referral_code);
        $stmt->bindParam(":lineup_date", $this->lineup_date);
        $stmt->bindParam(":source_id", $this->source_id);
        $stmt->bindParam(":profile_id", $this->profile_id);
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":added_date", $this->added_date);
        $stmt->bindParam(":created_by", $this->created_by);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function read() {
        $query = "SELECT c.id, c.candidate_id, c.name, c.email, c.phone, c.location, c.team_name, c.referral_code, 
                         c.lineup_date, c.status, c.added_date, s.name as source_name, 
                         p.name as profile_name, c.created_at, c.updated_at
                  FROM " . $this->table_name . " c
                  LEFT JOIN sources s ON c.source_id = s.id
                  LEFT JOIN profiles p ON c.profile_id = p.id
                  ORDER BY c.created_at DESC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function search($filters) {
        $query = "SELECT c.id, c.candidate_id, c.name, c.email, c.phone, c.location, c.team_name, c.referral_code,
                         c.lineup_date, c.status, c.added_date, s.name as source_name, 
                         p.name as profile_name, c.created_at, c.updated_at
                  FROM " . $this->table_name . " c
                  LEFT JOIN sources s ON c.source_id = s.id
                  LEFT JOIN profiles p ON c.profile_id = p.id
                  WHERE 1=1";
        
        $params = array();
        
        if (!empty($filters['candidate_id'])) {
            $query .= " AND c.candidate_id LIKE ?";
            $params[] = "%" . $filters['candidate_id'] . "%";
        }
        
        if (!empty($filters['name'])) {
            $query .= " AND c.name LIKE ?";
            $params[] = "%" . $filters['name'] . "%";
        }
        
        if (!empty($filters['email'])) {
            $query .= " AND c.email LIKE ?";
            $params[] = "%" . $filters['email'] . "%";
        }
        
        if (!empty($filters['phone'])) {
            $query .= " AND c.phone LIKE ?";
            $params[] = "%" . $filters['phone'] . "%";
        }
        if (!empty($filters['location'])) {
            $query .= " AND c.location LIKE ?";
            $params[] = "%" . $filters['location'] . "%";
        }
        if (!empty($filters['team_name'])) {
            $query .= " AND c.team_name LIKE ?";
            $params[] = "%" . $filters['team_name'] . "%";
        }
        
        if (!empty($filters['referral_code'])) {
            $query .= " AND c.referral_code LIKE ?";
            $params[] = "%" . $filters['referral_code'] . "%";
        }
        
        if (!empty($filters['lineup_date'])) {
            $query .= " AND c.lineup_date = ?";
            $params[] = $filters['lineup_date'];
        }
        
        if (!empty($filters['source_id'])) {
            $query .= " AND c.source_id = ?";
            $params[] = $filters['source_id'];
        }
        
        if (!empty($filters['profile_id'])) {
            $query .= " AND c.profile_id = ?";
            $params[] = $filters['profile_id'];
        }
        
        if (!empty($filters['status'])) {
            $query .= " AND c.status = ?";
            $params[] = $filters['status'];
        }
        
        $query .= " ORDER BY c.created_at DESC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute($params);
        return $stmt;
    }

    public function readOne() {
        $query = "SELECT c.id, c.candidate_id, c.name, c.email, c.phone, c.location, c.team_name, c.referral_code,
                         c.lineup_date, c.status, c.added_date, c.source_id, c.profile_id,
                         s.name as source_name, p.name as profile_name,
                         c.created_at, c.updated_at
                  FROM " . $this->table_name . " c
                  LEFT JOIN sources s ON c.source_id = s.id
                  LEFT JOIN profiles p ON c.profile_id = p.id
                  WHERE c.candidate_id = ? LIMIT 0,1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->candidate_id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if($row) {
            $this->id = $row['id'];
            $this->name = $row['name'];
            $this->email = $row['email'];
            $this->phone = $row['phone'];
            $this->location = $row['location'];
            $this->team_name = $row['team_name'];
            $this->referral_code = $row['referral_code'];
            $this->lineup_date = $row['lineup_date'];
            $this->status = $row['status'];
            $this->added_date = $row['added_date'];
            $this->source_id = $row['source_id'];
            $this->profile_id = $row['profile_id'];
            return true;
        }
        return false;
    }

    public function update() {
        $query = "UPDATE " . $this->table_name . " 
                  SET name=:name, email=:email, phone=:phone, location=:location, team_name=:team_name, referral_code=:referral_code,
                      lineup_date=:lineup_date, source_id=:source_id, profile_id=:profile_id, 
                      status=:status
                  WHERE candidate_id=:candidate_id";

        $stmt = $this->conn->prepare($query);

        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->email = htmlspecialchars(strip_tags($this->email));
        $this->phone = htmlspecialchars(strip_tags($this->phone));
        $this->location = htmlspecialchars(strip_tags($this->location));
        $this->team_name = htmlspecialchars(strip_tags($this->team_name));
        $this->referral_code = htmlspecialchars(strip_tags($this->referral_code));
        $this->status = htmlspecialchars(strip_tags($this->status));

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':email', $this->email);
        $stmt->bindParam(':phone', $this->phone);
        $stmt->bindParam(':location', $this->location);
        $stmt->bindParam(':team_name', $this->team_name);
        $stmt->bindParam(':referral_code', $this->referral_code);
        $stmt->bindParam(':lineup_date', $this->lineup_date);
        $stmt->bindParam(':source_id', $this->source_id);
        $stmt->bindParam(':profile_id', $this->profile_id);
        $stmt->bindParam(':status', $this->status);
        $stmt->bindParam(':candidate_id', $this->candidate_id);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function generateCandidateId() {
        $query = "SELECT candidate_id FROM " . $this->table_name . " ORDER BY id DESC LIMIT 1";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if($row) {
            $lastId = intval(substr($row['candidate_id'], 3)); // Remove 'IX-' prefix
            $newId = $lastId + 1;
        } else {
            $newId = 10001;
        }
        
        return 'IX-' . $newId;
    }

    public function getStats() {
        $query = "SELECT 
                    COUNT(*) as total,
                    SUM(CASE WHEN status = 'selected' THEN 1 ELSE 0 END) as selected,
                    SUM(CASE WHEN status = 'joined' THEN 1 ELSE 0 END) as joined,
                    SUM(CASE WHEN status IN ('pending', 'shortlisted') THEN 1 ELSE 0 END) as pending,
                    SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected
                  FROM " . $this->table_name;
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
