<?php
class Interview {
    private $conn;
    private $table_name = "interviews";

    public $id;
    public $candidate_id;
    public $interview_date;
    public $interview_time;
    public $interview_type;
    public $duration_minutes;
    public $interviewer_id;
    public $interviewer_name;
    public $status;
    public $result;
    public $notes;
    public $next_interview_date;
    public $next_interview_type;
    public $created_at;

    public function __construct($db){
        $this->conn = $db;
    }

    public function read(){
        $query = "SELECT i.*, c.candidate_id as candidate_code, c.name as candidate_name
                  FROM " . $this->table_name . " i
                  LEFT JOIN candidates c ON i.candidate_id = c.id
                  ORDER BY i.created_at DESC";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readByCandidate($candidate_id) {
        $query = "SELECT i.*, 
                         CASE 
                             WHEN i.interviewer_name IS NOT NULL THEN i.interviewer_name
                             WHEN u.username IS NOT NULL THEN u.username
                             ELSE 'N/A'
                         END as interviewer_name
                  FROM interviews i 
                  LEFT JOIN users u ON i.interviewer_id = u.id
                  WHERE i.candidate_id = ? 
                  ORDER BY i.interview_date DESC, i.created_at DESC";
    
        $stmt = $this->conn->prepare($query);
        $stmt->execute([$candidate_id]);
        return $stmt;
    }

    public function getInterviewHistory($candidate_id) {
        $query = "SELECT i.*, 
                         c.candidate_id as candidate_code,
                         c.name as candidate_name,
                         CASE 
                             WHEN i.interviewer_name IS NOT NULL THEN i.interviewer_name
                             WHEN u.username IS NOT NULL THEN u.username
                             ELSE 'System'
                         END as interviewer_display_name
                  FROM interviews i
                  LEFT JOIN candidates c ON i.candidate_id = c.id
                  LEFT JOIN users u ON i.interviewer_id = u.id
                  WHERE i.candidate_id = ?
                  ORDER BY i.interview_date DESC, i.created_at DESC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute([$candidate_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getUpcomingInterviews() {
        $query = "SELECT i.*, 
                         c.candidate_id as candidate_code,
                         c.name as candidate_name,
                         c.phone as candidate_phone,
                         c.email as candidate_email
                  FROM interviews i
                  LEFT JOIN candidates c ON i.candidate_id = c.id
                  WHERE i.status = 'scheduled' 
                  AND i.interview_date >= CURDATE()
                  ORDER BY i.interview_date ASC, i.interview_time ASC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getTodaysInterviews() {
        $query = "SELECT i.*, 
                         c.candidate_id as candidate_code,
                         c.name as candidate_name,
                         c.phone as candidate_phone,
                         c.email as candidate_email
                  FROM interviews i
                  LEFT JOIN candidates c ON i.candidate_id = c.id
                  WHERE i.interview_date = CURDATE()
                  ORDER BY i.interview_time ASC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getInterviewStats() {
        $query = "SELECT 
                    COUNT(*) as total_interviews,
                    SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed,
                    SUM(CASE WHEN status = 'scheduled' THEN 1 ELSE 0 END) as scheduled,
                    SUM(CASE WHEN result = 'selected' THEN 1 ELSE 0 END) as selected,
                    SUM(CASE WHEN result = 'rejected' THEN 1 ELSE 0 END) as rejected,
                    SUM(CASE WHEN result = 'shortlisted' THEN 1 ELSE 0 END) as shortlisted,
                    SUM(CASE WHEN result = 'hold' THEN 1 ELSE 0 END) as on_hold
                  FROM interviews
                  WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
