<?php
include_once 'includes/session.php';
checkLogin();

include_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Get dashboard statistics
$stats = [];

// Total candidates
$query = "SELECT COUNT(*) as total FROM candidates";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['total_candidates'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Pending candidates
$query = "SELECT COUNT(*) as total FROM candidates WHERE status = 'pending'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['pending_candidates'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Selected candidates
$query = "SELECT COUNT(*) as total FROM candidates WHERE status = 'selected'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['selected_candidates'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Joined candidates
$query = "SELECT COUNT(*) as total FROM candidates WHERE status = 'joined'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['joined_candidates'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Today's interviews
$query = "SELECT COUNT(*) as total FROM interviews WHERE interview_date = CURDATE() AND status = 'scheduled'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['todays_interviews'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Recent candidates (last 7 days)
$query = "SELECT c.*, u.username as added_by_name FROM candidates c 
          LEFT JOIN users u ON c.added_by = u.id 
          WHERE c.added_date >= DATE_SUB(NOW(), INTERVAL 7 DAY) 
          ORDER BY c.added_date DESC LIMIT 10";
$stmt = $db->prepare($query);
$stmt->execute();
$recent_candidates = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Upcoming interviews (next 7 days)
$query = "SELECT i.*, c.name as candidate_name, c.candidate_id 
          FROM interviews i 
          JOIN candidates c ON i.candidate_id = c.id 
          WHERE i.interview_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 7 DAY) 
          AND i.status = 'scheduled'
          ORDER BY i.interview_date ASC, i.interview_time ASC LIMIT 10";
$stmt = $db->prepare($query);
$stmt->execute();
$upcoming_interviews = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - HR Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            margin: 2px 0;
            border-radius: 8px;
            transition: all 0.3s ease;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
        }
        .stat-card {
            border-radius: 15px;
            border: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: white;
        }
        .bg-primary-gradient { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .bg-success-gradient { background: linear-gradient(135deg, #56ab2f 0%, #a8e6cf 100%); }
        .bg-warning-gradient { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
        .bg-info-gradient { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
        .bg-danger-gradient { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }
        
        .table-hover tbody tr:hover {
            background-color: rgba(102, 126, 234, 0.1);
        }
        .badge-status {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 d-md-block sidebar collapse">
                <div class="position-sticky pt-3">
                    <div class="text-center mb-4">
                        <h4 class="text-white">
                            <i class="fas fa-users me-2"></i>
                            HR Portal
                        </h4>
                        <small class="text-white-50">Welcome, <?php echo $_SESSION['username']; ?></small>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="add-candidate.html">
                                <i class="fas fa-user-plus me-2"></i>
                                Add Candidate
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="search-candidates.php">
                                <i class="fas fa-search me-2"></i>
                                Search Candidates
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="process-interview.php">
                                <i class="fas fa-clipboard-list me-2"></i>
                                Interview Process
                            </a>
                        </li>
                        <?php if (isAdmin()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="manage-options.php">
                                <i class="fas fa-cogs me-2"></i>
                                Manage Options
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="admin-users.php">
                                <i class="fas fa-users-cog me-2"></i>
                                Manage Users
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item mt-3">
                            <a class="nav-link" href="logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>
                                Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">
                                <i class="fas fa-calendar me-1"></i>
                                <?php echo date('M d, Y'); ?>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stat-card">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Candidates
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $stats['total_candidates']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <div class="stat-icon bg-primary-gradient">
                                            <i class="fas fa-users"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stat-card">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Pending
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $stats['pending_candidates']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <div class="stat-icon bg-warning-gradient">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stat-card">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Selected
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $stats['selected_candidates']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <div class="stat-icon bg-success-gradient">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stat-card">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Today's Interviews
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $stats['todays_interviews']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <div class="stat-icon bg-info-gradient">
                                            <i class="fas fa-calendar-day"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-user-plus me-2"></i>
                                    Recent Candidates
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Name</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                                <th>Added Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($recent_candidates as $candidate): ?>
                                            <tr>
                                                <td><?php echo $candidate['candidate_id']; ?></td>
                                                <td><?php echo $candidate['name']; ?></td>
                                                <td>
                                                    <span class="badge badge-status bg-<?php 
                                                        echo $candidate['status'] == 'selected' ? 'success' : 
                                                            ($candidate['status'] == 'pending' ? 'warning' : 
                                                            ($candidate['status'] == 'rejected' ? 'danger' : 'secondary')); 
                                                    ?>">
                                                        <?php echo ucfirst($candidate['status']); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo $candidate['source']; ?></td>
                                                <td><?php echo date('M d, Y', strtotime($candidate['added_date'])); ?></td>
                                                <td>
                                                    <a href="view-candidate.php?id=<?php echo $candidate['id']; ?>" 
                                                       class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-calendar-alt me-2"></i>
                                    Upcoming Interviews
                                </h5>
                            </div>
                            <div class="card-body">
                                <?php if (empty($upcoming_interviews)): ?>
                                    <p class="text-muted text-center">No upcoming interviews</p>
                                <?php else: ?>
                                    <?php foreach ($upcoming_interviews as $interview): ?>
                                    <div class="d-flex align-items-center mb-3 p-2 border rounded">
                                        <div class="flex-shrink-0">
                                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" 
                                                 style="width: 40px; height: 40px;">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6 class="mb-1"><?php echo $interview['candidate_name']; ?></h6>
                                            <small class="text-muted">
                                                <?php echo date('M d, Y', strtotime($interview['interview_date'])); ?>
                                                <?php if ($interview['interview_time']): ?>
                                                    at <?php echo date('g:i A', strtotime($interview['interview_time'])); ?>
                                                <?php endif; ?>
                                            </small>
                                            <br>
                                            <small class="badge bg-info"><?php echo ucfirst($interview['interview_type']); ?></small>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
