<?php
include_once 'includes/session.php';

// Check if user is already logged in
if (isLoggedIn()) {
    // Redirect to dashboard if already logged in
    header("Location: dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .welcome-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            padding: 50px;
            text-align: center;
            max-width: 600px;
            width: 100%;
            margin: 20px;
        }
        .welcome-icon {
            font-size: 5rem;
            color: #667eea;
            margin-bottom: 30px;
        }
        .welcome-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #333;
            margin-bottom: 20px;
        }
        .welcome-subtitle {
            font-size: 1.2rem;
            color: #666;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        .btn-get-started {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            font-size: 1.1rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
        }
        .btn-get-started:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(102, 126, 234, 0.4);
        }
        .features {
            margin-top: 50px;
        }
        .feature-item {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            text-align: left;
        }
        .feature-icon {
            font-size: 1.5rem;
            color: #667eea;
            margin-right: 15px;
            width: 30px;
        }
        .feature-text {
            color: #555;
            font-size: 1rem;
        }
        .system-info {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-top: 30px;
            border-left: 4px solid #667eea;
        }
        .demo-credentials {
            background: #e3f2fd;
            border-radius: 8px;
            padding: 15px;
            margin-top: 20px;
            border: 1px solid #bbdefb;
        }
    </style>
</head>
<body>
    <div class="welcome-container">
        <div class="welcome-icon">
            <i class="fas fa-users"></i>
        </div>
        
        <h1 class="welcome-title">Candidate Management System</h1>
        
        <p class="welcome-subtitle">
            Streamline your recruitment process with our comprehensive candidate management solution. 
            Track candidates, manage interviews, and make informed hiring decisions.
        </p>
        
        <a href="login.php" class="btn btn-primary btn-get-started">
            <i class="fas fa-sign-in-alt me-2"></i>Get Started
        </a>
        
        <div class="features">
            <div class="row">
                <div class="col-md-6">
                    <div class="feature-item">
                        <i class="fas fa-user-plus feature-icon"></i>
                        <span class="feature-text">Add & Manage Candidates</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-search feature-icon"></i>
                        <span class="feature-text">Advanced Search & Filtering</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-clipboard-list feature-icon"></i>
                        <span class="feature-text">Interview Process Tracking</span>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="feature-item">
                        <i class="fas fa-chart-bar feature-icon"></i>
                        <span class="feature-text">Dashboard & Analytics</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-cogs feature-icon"></i>
                        <span class="feature-text">Customizable Sources & Profiles</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-print feature-icon"></i>
                        <span class="feature-text">Print & Export Reports</span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="demo-credentials">
            <h6><i class="fas fa-key me-2"></i>Demo Credentials</h6>
            <p class="mb-1"><strong>Username:</strong> admin</p>
            <p class="mb-0"><strong>Password:</strong> password</p>
        </div>
        
        <div class="system-info">
            <h6><i class="fas fa-info-circle me-2"></i>System Information</h6>
            <p class="mb-2">
                <strong>Version:</strong> 1.0.0 | 
                <strong>Technology:</strong> PHP, MySQL, Bootstrap 5
            </p>
            <p class="mb-0">
                <small class="text-muted">
                    Need help? Contact your system administrator or check the documentation.
                </small>
            </p>
        </div>
        
        <div class="mt-4">
            <small class="text-muted">
                <a href="install.php" class="text-decoration-none">
                    <i class="fas fa-tools me-1"></i>System Setup
                </a>
            </small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
