<?php
// Simple installation script to create default admin user
include_once 'config/database.php';
include_once 'classes/User.php';

$database = new Database();
$db = $database->getConnection();

if ($db) {
    echo "<h2>Database Connection Successful!</h2>";
    
    // Create default admin user
    $user = new User($db);
    $user->username = "admin";
    $user->password_hash = "password"; // This will be hashed in the create method
    $user->email = "admin@company.com";
    $user->role = "admin";
    
    if ($user->create()) {
        echo "<p>✅ Default admin user created successfully!</p>";
        echo "<p><strong>Username:</strong> admin</p>";
        echo "<p><strong>Password:</strong> password</p>";
    } else {
        echo "<p>❌ Failed to create admin user (may already exist)</p>";
    }
    
    echo "<p><a href='login.php' class='btn btn-primary'>Go to Login</a></p>";
} else {
    echo "<h2>❌ Database Connection Failed!</h2>";
    echo "<p>Please check your database configuration in config/database.php</p>";
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Installation - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3>Candidate Management System - Installation</h3>
                    </div>
                    <div class="card-body">
                        <!-- PHP output will appear here -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
