<?php
include_once 'config/database.php';
include_once 'classes/Source.php';
include_once 'classes/Profile.php';
include_once 'includes/session.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();
$source = new Source($db);
$profile = new Profile($db);

$success_message = '';
$error_message = '';

// Handle form submissions
if ($_POST) {
    if (isset($_POST['add_source'])) {
        $source->name = $_POST['source_name'];
        $source->description = $_POST['source_description'] ?? '';
        if ($source->create()) {
            $success_message = "Source added successfully!";
        } else {
            $error_message = "Failed to add source!";
        }
    } elseif (isset($_POST['add_profile'])) {
        $profile->name = $_POST['profile_name'];
        $profile->description = $_POST['profile_description'] ?? '';
        $profile->department = $_POST['profile_department'] ?? '';
        if ($profile->create()) {
            $success_message = "Profile added successfully!";
        } else {
            $error_message = "Failed to add profile!";
        }
    } elseif (isset($_POST['delete_source'])) {
        $source->id = $_POST['source_id'];
        if ($source->delete()) {
            $success_message = "Source deleted successfully!";
        } else {
            $error_message = "Failed to delete source!";
        }
    } elseif (isset($_POST['delete_profile'])) {
        $profile->id = $_POST['profile_id'];
        if ($profile->delete()) {
            $success_message = "Profile deleted successfully!";
        } else {
            $error_message = "Failed to delete profile!";
        }
    }
}

// Get current sources and profiles
$sources_stmt = $source->read();
$profiles_stmt = $profile->read();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Sources & Profiles - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .management-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin: 20px 0;
        }
        .option-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 15px;
            margin: 5px 0;
            background-color: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        .option-item:hover {
            background-color: #e9ecef;
        }
        .btn-delete {
            background: none;
            border: none;
            color: #dc3545;
            font-size: 1.1rem;
        }
        .btn-delete:hover {
            color: #c82333;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">
                <i class="fas fa-users me-2"></i>
                Candidate Management System
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">
                    <i class="fas fa-home me-1"></i>Dashboard
                </a>
                <a href="logout.php" class="btn btn-outline-light btn-sm ms-2">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <?php if ($success_message): ?>
            <div class="alert alert-success alert-dismissible fade show mt-3">
                <i class="fas fa-check-circle me-2"></i><?php echo $success_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if ($error_message): ?>
            <div class="alert alert-danger alert-dismissible fade show mt-3">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo $error_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <div class="management-container">
                    <h3 class="mb-4">
                        <i class="fas fa-source-fork me-2"></i>Manage Sources
                    </h3>
                    
                    <form method="POST" class="mb-4">
                        <div class="input-group mb-2">
                            <input type="text" class="form-control" name="source_name" placeholder="Enter source name" required>
                            <button type="submit" name="add_source" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Add Source
                            </button>
                        </div>
                        <input type="text" class="form-control" name="source_description" placeholder="Description (optional)">
                    </form>
                    
                    <div id="sourcesList">
                        <?php while ($row = $sources_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                            <div class="option-item">
                                <div>
                                    <strong><?php echo htmlspecialchars($row['name']); ?></strong>
                                    <?php if ($row['description']): ?>
                                        <br><small class="text-muted"><?php echo htmlspecialchars($row['description']); ?></small>
                                    <?php endif; ?>
                                </div>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="source_id" value="<?php echo $row['id']; ?>">
                                    <button type="submit" name="delete_source" class="btn-delete" 
                                            onclick="return confirm('Are you sure you want to delete this source?')" 
                                            title="Delete source">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="management-container">
                    <h3 class="mb-4">
                        <i class="fas fa-user-tag me-2"></i>Manage Profiles
                    </h3>
                    
                    <form method="POST" class="mb-4">
                        <div class="input-group mb-2">
                            <input type="text" class="form-control" name="profile_name" placeholder="Enter profile name" required>
                            <button type="submit" name="add_profile" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Add Profile
                            </button>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="profile_description" placeholder="Description (optional)">
                            </div>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="profile_department" placeholder="Department (optional)">
                            </div>
                        </div>
                    </form>
                    
                    <div id="profilesList">
                        <?php while ($row = $profiles_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                            <div class="option-item">
                                <div>
                                    <strong><?php echo htmlspecialchars($row['name']); ?></strong>
                                    <?php if ($row['department']): ?>
                                        <span class="badge bg-secondary"><?php echo htmlspecialchars($row['department']); ?></span>
                                    <?php endif; ?>
                                    <?php if ($row['description']): ?>
                                        <br><small class="text-muted"><?php echo htmlspecialchars($row['description']); ?></small>
                                    <?php endif; ?>
                                </div>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="profile_id" value="<?php echo $row['id']; ?>">
                                    <button type="submit" name="delete_profile" class="btn-delete" 
                                            onclick="return confirm('Are you sure you want to delete this profile?')" 
                                            title="Delete profile">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
