<?php
// Final database migration script with referral code support
include_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    echo "<h2>Final Database Migration - Adding Referral Code Support</h2>";
    
    // Step 1: Add referral_code column to candidates table
    echo "<h3>Step 1: Adding referral_code column</h3>";
    $check_referral_query = "SHOW COLUMNS FROM candidates LIKE 'referral_code'";
    $result = $db->query($check_referral_query);
    
    if ($result->rowCount() == 0) {
        $add_referral_query = "ALTER TABLE candidates ADD COLUMN referral_code VARCHAR(50) AFTER phone, ADD INDEX idx_referral_code (referral_code)";
        try {
            $db->exec($add_referral_query);
            echo "<p style='color: green;'>✓ Added referral_code column to candidates table</p>";
        } catch (Exception $e) {
            echo "<p style='color: red;'>✗ Failed to add referral_code column: " . $e->getMessage() . "</p>";
        }
    } else {
        echo "<p style='color: blue;'>ℹ referral_code column already exists</p>";
    }
    
    // Step 2: Check and add missing columns to interviews table
    echo "<h3>Step 2: Checking interviews table columns</h3>";
    $interview_columns = [
        'duration_minutes' => 'INT',
        'next_interview_type' => "ENUM('initial', 'technical', 'hr', 'final') DEFAULT 'initial'"
    ];
    
    foreach ($interview_columns as $column => $definition) {
        $check_query = "SHOW COLUMNS FROM interviews LIKE '$column'";
        $result = $db->query($check_query);
        
        if ($result->rowCount() == 0) {
            $alter_query = "ALTER TABLE interviews ADD COLUMN $column $definition";
            try {
                $db->exec($alter_query);
                echo "<p style='color: green;'>✓ Added column '$column' to interviews table</p>";
            } catch (Exception $e) {
                echo "<p style='color: red;'>✗ Failed to add column '$column': " . $e->getMessage() . "</p>";
            }
        } else {
            echo "<p style='color: blue;'>ℹ Column '$column' already exists in interviews table</p>";
        }
    }
    
    // Step 3: Check and add missing columns to joining_details table
    echo "<h3>Step 3: Checking joining_details table columns</h3>";
    $joining_columns = [
        'expected_joining_date' => 'DATE',
        'work_location' => 'VARCHAR(100)',
        'joining_notes' => 'TEXT',
        'joining_feedback' => 'TEXT'
    ];
    
    foreach ($joining_columns as $column => $definition) {
        $check_query = "SHOW COLUMNS FROM joining_details LIKE '$column'";
        $result = $db->query($check_query);
        
        if ($result->rowCount() == 0) {
            $alter_query = "ALTER TABLE joining_details ADD COLUMN $column $definition";
            try {
                $db->exec($alter_query);
                echo "<p style='color: green;'>✓ Added column '$column' to joining_details table</p>";
            } catch (Exception $e) {
                echo "<p style='color: red;'>✗ Failed to add column '$column': " . $e->getMessage() . "</p>";
            }
        } else {
            echo "<p style='color: blue;'>ℹ Column '$column' already exists in joining_details table</p>";
        }
    }
    
    // Step 4: Update ENUM values
    echo "<h3>Step 4: Updating ENUM values</h3>";
    $enum_updates = [
        "ALTER TABLE interviews MODIFY COLUMN interview_type ENUM('initial', 'technical', 'hr', 'final', 'reschedule', 'process_ended') DEFAULT 'initial'",
        "ALTER TABLE interviews MODIFY COLUMN result ENUM('pending', 'shortlisted', 'selected', 'rejected', 'hold', 'process_ended') DEFAULT 'pending'",
        "ALTER TABLE candidates MODIFY COLUMN status ENUM('pending', 'shortlisted', 'selected', 'rejected', 'hold', 'joined', 'selected_not_joined', 'rescheduled', 'process_ended') DEFAULT 'pending'"
    ];
    
    foreach ($enum_updates as $query) {
        try {
            $db->exec($query);
            echo "<p style='color: green;'>✓ Updated ENUM values successfully</p>";
        } catch (Exception $e) {
            echo "<p style='color: orange;'>⚠ ENUM update warning (may already be updated): " . $e->getMessage() . "</p>";
        }
    }
    
    // Step 5: Verify table structures
    echo "<h3>Step 5: Verification</h3>";
    $tables_to_verify = ['candidates', 'interviews', 'joining_details'];
    
    foreach ($tables_to_verify as $table) {
        $verify_query = "DESCRIBE $table";
        $result = $db->query($verify_query);
        $columns = $result->fetchAll(PDO::FETCH_ASSOC);
        echo "<h4>Table: $table</h4>";
        echo "<ul>";
        foreach ($columns as $column) {
            echo "<li><strong>" . $column['Field'] . "</strong>: " . $column['Type'] . "</li>";
        }
        echo "</ul>";
    }
    
    echo "<div style='background: #d4edda; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3 style='color: #155724;'>✅ Database Migration Completed Successfully!</h3>";
    echo "<p>All required columns have been added and the database is ready for use with referral code support.</p>";
    echo "<p><strong>New Features Available:</strong></p>";
    echo "<ul>";
    echo "<li>Referral code field in candidate forms</li>";
    echo "<li>Referral code search and filtering</li>";
    echo "<li>Referral code in Excel exports and print views</li>";
    echo "<li>Enhanced interview tracking with duration and next interview type</li>";
    echo "<li>Complete joining details management</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<p><a href='../dashboard.php' class='btn btn-primary'>Go to Dashboard</a></p>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3 style='color: #721c24;'>❌ Database Migration Failed</h3>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "</div>";
}
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
h2, h3, h4 { color: #333; }
.btn { 
    display: inline-block; 
    padding: 10px 20px; 
    background: #007bff; 
    color: white; 
    text-decoration: none; 
    border-radius: 5px; 
}
.btn:hover { background: #0056b3; }
ul { margin: 10px 0; }
li { margin: 5px 0; }
</style>
