<?php
// Complete database setup script
include_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    echo "<h2>Database Setup and Migration</h2>";
    
    // Check if tables exist and add missing columns
    $tables_to_check = [
        'interviews' => [
            'duration_minutes' => 'INT',
            'next_interview_type' => "ENUM('initial', 'technical', 'hr', 'final') DEFAULT 'initial'"
        ],
        'joining_details' => [
            'expected_joining_date' => 'DATE',
            'work_location' => 'VARCHAR(100)',
            'joining_notes' => 'TEXT',
            'joining_feedback' => 'TEXT'
        ]
    ];
    
    foreach ($tables_to_check as $table => $columns) {
        echo "<h3>Checking table: $table</h3>";
        
        foreach ($columns as $column => $definition) {
            // Check if column exists
            $check_query = "SHOW COLUMNS FROM $table LIKE '$column'";
            $result = $db->query($check_query);
            
            if ($result->rowCount() == 0) {
                // Column doesn't exist, add it
                $alter_query = "ALTER TABLE $table ADD COLUMN $column $definition";
                try {
                    $db->exec($alter_query);
                    echo "<p style='color: green;'>✓ Added column '$column' to table '$table'</p>";
                } catch (Exception $e) {
                    echo "<p style='color: red;'>✗ Failed to add column '$column' to table '$table': " . $e->getMessage() . "</p>";
                }
            } else {
                echo "<p style='color: blue;'>ℹ Column '$column' already exists in table '$table'</p>";
            }
        }
    }
    
    // Update enum values for existing columns
    $enum_updates = [
        "ALTER TABLE interviews MODIFY COLUMN interview_type ENUM('initial', 'technical', 'hr', 'final', 'reschedule', 'process_ended') DEFAULT 'initial'",
        "ALTER TABLE interviews MODIFY COLUMN result ENUM('pending', 'shortlisted', 'selected', 'rejected', 'hold', 'process_ended') DEFAULT 'pending'"
    ];
    
    echo "<h3>Updating ENUM values</h3>";
    foreach ($enum_updates as $query) {
        try {
            $db->exec($query);
            echo "<p style='color: green;'>✓ Updated ENUM values successfully</p>";
        } catch (Exception $e) {
            echo "<p style='color: orange;'>⚠ ENUM update warning (may already be updated): " . $e->getMessage() . "</p>";
        }
    }
    
    echo "<h3>Database setup completed successfully!</h3>";
    echo "<p><a href='../dashboard.php'>Go to Dashboard</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Database setup failed: " . $e->getMessage() . "</p>";
}
?>
