<?php
// Database configuration
$host = 'localhost';
$dbname = 'candidate_management';
$username = 'your_username';
$password = 'your_password';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Connected to database successfully!\n";
    
    // Import Sources (if not already imported from seed data)
    echo "Importing sources...\n";
    
    // Import Profiles (if not already imported from seed data)
    echo "Importing profiles...\n";
    
    // Import Candidates
    echo "Importing candidates...\n";
    importCandidates($pdo, 'sample-data/candidates.csv');
    
    // Import Interviews
    echo "Importing interviews...\n";
    importInterviews($pdo, 'sample-data/interviews.csv');
    
    // Import Joining Details
    echo "Importing joining details...\n";
    importJoiningDetails($pdo, 'sample-data/joining_details.csv');
    
    // Import Reschedules
    echo "Importing reschedules...\n";
    importReschedules($pdo, 'sample-data/reschedules.csv');
    
    echo "Data import completed successfully!\n";
    
} catch(PDOException $e) {
    echo "Connection failed: " . $e->getMessage() . "\n";
}

function importCandidates($pdo, $csvFile) {
    $file = fopen($csvFile, 'r');
    $header = fgetcsv($file); // Skip header row
    
    $stmt = $pdo->prepare("
        INSERT INTO candidates (candidate_id, name, email, phone, lineup_date, source_id, profile_id, status, added_date, created_by) 
        VALUES (?, ?, ?, ?, ?, 
                (SELECT id FROM sources WHERE name = ?), 
                (SELECT id FROM profiles WHERE name = ?), 
                ?, ?, 1)
    ");
    
    while (($data = fgetcsv($file)) !== FALSE) {
        $stmt->execute([
            $data[0], // candidate_id
            $data[1], // name
            $data[2], // email
            $data[3], // phone
            $data[4], // lineup_date
            $data[5], // source
            $data[6], // profile
            $data[7], // status
            $data[8]  // added_date
        ]);
    }
    
    fclose($file);
    echo "Candidates imported successfully!\n";
}

function importInterviews($pdo, $csvFile) {
    $file = fopen($csvFile, 'r');
    $header = fgetcsv($file); // Skip header row
    
    $stmt = $pdo->prepare("
        INSERT INTO interviews (candidate_id, interview_date, interview_type, status, result, interviewer_name, notes, next_interview_date) 
        VALUES ((SELECT id FROM candidates WHERE candidate_id = ?), ?, ?, ?, ?, ?, ?, ?)
    ");
    
    while (($data = fgetcsv($file)) !== FALSE) {
        $stmt->execute([
            $data[0], // candidate_id
            $data[1], // interview_date
            $data[2], // interview_type
            $data[3], // status
            $data[4], // result
            $data[5], // interviewer_name
            $data[6], // notes
            !empty($data[7]) ? $data[7] : null // next_interview_date
        ]);
    }
    
    fclose($file);
    echo "Interviews imported successfully!\n";
}

function importJoiningDetails($pdo, $csvFile) {
    $file = fopen($csvFile, 'r');
    $header = fgetcsv($file); // Skip header row
    
    $stmt = $pdo->prepare("
        INSERT INTO joining_details (candidate_id, joining_date, actual_joining_date, joining_status, salary_offered, department, position, reporting_manager, notes) 
        VALUES ((SELECT id FROM candidates WHERE candidate_id = ?), ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    
    while (($data = fgetcsv($file)) !== FALSE) {
        $stmt->execute([
            $data[0], // candidate_id
            $data[1], // joining_date
            !empty($data[2]) ? $data[2] : null, // actual_joining_date
            $data[3], // joining_status
            $data[4], // salary_offered
            $data[5], // department
            $data[6], // position
            $data[7], // reporting_manager
            $data[8]  // notes
        ]);
    }
    
    fclose($file);
    echo "Joining details imported successfully!\n";
}

function importReschedules($pdo, $csvFile) {
    $file = fopen($csvFile, 'r');
    $header = fgetcsv($file); // Skip header row
    
    $stmt = $pdo->prepare("
        INSERT INTO reschedules (candidate_id, original_date, new_date, reason, reason_details, rescheduled_by) 
        VALUES ((SELECT id FROM candidates WHERE candidate_id = ?), ?, ?, ?, ?, 
                (SELECT id FROM users WHERE username = ?))
    ");
    
    while (($data = fgetcsv($file)) !== FALSE) {
        $stmt->execute([
            $data[0], // candidate_id
            $data[1], // original_date
            $data[2], // new_date
            $data[3], // reason
            $data[4], // reason_details
            $data[5]  // rescheduled_by
        ]);
    }
    
    fclose($file);
    echo "Reschedules imported successfully!\n";
}
?>
